//Copyright  2011, Mario aka Mario222

//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
//AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
//IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
//ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
//LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
//CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
//INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
//CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
//OF THE POSSIBILITY OF SUCH DAMAGE.

using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Bubble_POP
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Pop : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SoundEffect pop;
        SoundEffectInstance popi;
        Texture2D backr;
        Texture2D resetbutten;
        Texture2D resetbutten2;
        Boolean[] bubble;
        //Boolean button;
        AccelerometerState state;
        SpriteBatch spriteBatch;
        const int n = 48;
        float elapsedTime;
        
        bubble[] bubblearray;

        int height, width;

        int x2, y, row;
        int holdx, holdy, holdrow;

        public Pop()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            // Frame rate is 30 fps by default for Zune.
            TargetElapsedTime = TimeSpan.FromSeconds(1 / 30.0);
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            bubble = new Boolean[n];
            bubblearray = new bubble[n];
            setTrue();
            holdx = 0;
            holdy = 0;
            holdrow = 0;

            base.Initialize();
        }

        public void setTrue()
        {
            for (int i = 0; i < n; i++)
                bubble[i] = true;


        }

        public void reset()
        {
            setTrue();

        }
        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);
            pop = Content.Load<SoundEffect>("pop");
            backr = Content.Load<Texture2D>("back");
            
            for(int i = 0; i<n;i++)
            {
                bubblearray[i] = new bubble(Content.Load<Texture2D>("b1"), Content.Load<Texture2D>("b2"), Content.Load<Texture2D>("b3"), Content.Load<Texture2D>("b4"), Content.Load<SoundEffect>("pop"), Content.Load<SoundEffect>("pop2"), Content.Load<SoundEffect>("pop3"));
            }
            resetbutten = Content.Load<Texture2D>("reset");
            resetbutten2 = Content.Load<Texture2D>("reset2");

            popi = pop.CreateInstance();

            height = bubblearray[0].getHeight();
            width = bubblearray[0].getWidth();
            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
            {
                this.Exit();
            }

            // TODO: Add your update logic here

            state = Accelerometer.GetState();
            Vector3 acc = state.Acceleration;

            TouchCollection touches = TouchPanel.GetState();

            foreach (TouchLocation location in touches)
            {
                for (int i = 0; i < n; i++)
               {
                    if ((location.Position.X > holdx && location.Position.X < holdx + (width+5) && location.Position.Y > holdy && location.Position.Y < holdy + (height+5))&& bubble[i] == !false)
                    {
                        bubblearray[i].sound().Play();
                       //popi.Play();
                        bubble[i] = false;
                    }
                    
                    if(holdx + 40 < 272)
                    {
                        holdx += width + 5;
                    }
                    else if (holdx + 40 >= 272 && holdrow == 1)
                    {
                        holdy += height + 5;
                        holdx = 10;
                        holdrow = 2;
                    }

                    else if (holdx + 40 >= 272 && holdrow == 2)
                    {
                        holdy += 55;
                        holdx = 0;
                        holdrow = 1;
                    }
                    
                }
                holdrow = 1;
                holdx = 0;
                holdy = 0;
               
                if ((location.Position.X > 229 && location.Position.X < 272 && location.Position.Y > 435 && location.Position.Y < 480))
                {
                    popi.Stop();
                    reset();
                    //reset feild
                }
            }



            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            //elapsedTime = (float)gameTime.ElapsedGameTime.Seconds;
            GraphicsDevice.Clear(Color.White);
            spriteBatch.Begin();
            spriteBatch.Draw(backr, new Vector2(0, 0), Color.White);

            

            x2 = 0;
            y = 0;
            row = 1;

            for (int i = 0; i < n; i++)// auto draw bubbles
            {  
                if (x2+40 < 272)
                {
                    spriteBatch.Draw(bubblearray[i].unPop(bubble[i]), new Vector2(x2, y), Color.White);
                    x2 += width + 5;
                }
  
               
                else if (x2+40 >= 272 && row == 1)
                {
                    y += height + 5;
                    x2 = 10;
                    row = 2;
                }
                else if (x2 + 40 >= 272 && row == 2)
                {
                    y += 55;
                    x2 = 0;
                    row = 1;
                }
                
               
            }
            

            //reset button
            spriteBatch.Draw(resetbutten, new Vector2(229, 435), Color.White);
            //reset button
            spriteBatch.End();

            row = 1;
            x2 = 0;
            y = 0;

            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
